<form action="{$VAL_SELF}" method="post" enctype="multipart/form-data">
	<div id="{$PLUGIN_NAME}" class="tab_content">
		<h3>{$PLUGIN_TITLE}</h3>

		<fieldset><legend>Configuration Settings</legend>
			<div><label for="status">{$LANG.common.status}</label><span><input type="hidden" name="module[status]" id="status" class="toggle" value="{$MODULE.status}" />&nbsp;</span></div>
			<div><label for="send_automated_emails">{$LANG.abandoned_carts.send_automated_emails}</label><span><input type="hidden" name="module[send_automated_emails]" id="send_automated_emails" class="toggle" value="{$MODULE.send_automated_emails}" />&nbsp;</span></div>
			<div><label for="minutes_before_abandoned">{$LANG.abandoned_carts.minutes_before_abandoned}</label><span><input type="text" name="module[minutes_before_abandoned]" id="minutes_before_abandoned" class="number" value="{$MODULE.minutes_before_abandoned}" />&nbsp;</span></div>
			<div><label for="minutes_before_expired">{$LANG.abandoned_carts.minutes_before_expired}</label><span><input type="text" name="module[minutes_before_expired]" id="minutes_before_expired" class="number" value="{$MODULE.minutes_before_expired}" />&nbsp;</span></div>
			<div><label for="total_emails_to_send">{$LANG.abandoned_carts.total_emails_to_send}</label><span><input type="text" name="module[total_emails_to_send]" id="total_emails_to_send" class="number" value="{$MODULE.total_emails_to_send}" />&nbsp;</span></div>
			<div><label for="total_emails_to_send">{$LANG.abandoned_carts.minutes_between_emails}</label><span><input type="text" name="module[minutes_between_emails]" id="minutes_between_emails" class="number" value="{$MODULE.minutes_between_emails}" />&nbsp;</span></div>
		</fieldset>

		<fieldset><legend>License Settings</legend>
			<div><label for="ndl_license_key">License Key</label><span><input name="module[ndl_license_key]" id="ndl_license_key" class="textbox" type="text" value="{$PLUGIN_LICENSE_KEY}" /></span></div>

			{$PLUGIN_LICENSE_STATUS}
			{$PLUGIN_SUPPORT_STATUS}
			{if isset($PLUGIN_SUPPORT_ENDS)}
				{$PLUGIN_SUPPORT_ENDS}	
			{/if}
			
			<input type="hidden" name="module[general_tab]" value="general_tab">
		</fieldset>

		<fieldset><legend>Plugin Version Information & Messages</legend>
			<div>Version: {$PLUGIN_VERSION} </div>
			{if isset($PLUGIN_MESSAGES)}
				{$PLUGIN_MESSAGES}
			{/if}
		</fieldset>	

		<div class="form_control">
		<input type="submit" value="{$LANG.common.save}" />
		</div>
		<input type="hidden" name="token" value="{$SESSION_TOKEN}" />
	</div>
</form>

<div id="current_abandoned_carts" class="tab_content">

	<style>
		.ac_opts{
			margin-left:20px;
		}
	</style>

	<h3>{$LANG.abandoned_carts.current_abandoned_carts}</h3>
	
	<table style="width:100%;">
		<thead>
			<tr>
				<td>{$LANG.abandoned_carts.age}</td>
				<td>{$LANG.abandoned_carts.customer_name}</td>
				<td>{$LANG.abandoned_carts.phone}</td>
				<td>{$LANG.abandoned_carts.email}</td>
				<td>{$LANG.abandoned_carts.cart_value}</td>
				<td>{$LANG.abandoned_carts.cart_items}</td>
				<td>{$LANG.abandoned_carts.number_of_sent_emails}</td>
				<td>{$LANG.abandoned_carts.send_email}</td>
			</tr>
		</thead>
		<tbody>
		
		{if isset($ABANDONED_CARTS) && $ABANDONED_CARTS != false}
			{foreach from=$ABANDONED_CARTS item=cart}
				<tr>
					<td>{$cart.age_total}</td>
					<td><a href="?_g=customers&action=edit&customer_id={$cart.customer_id}">{$cart.customer_name}</a></td>
					<td>{$cart.phone}</td>
					<td><a href="mailto:{$cart.email}">{$cart.email}</a></td>
					<td>{$cart.cart_value}</td>
					<td>
					
					{foreach from=$cart.basket_data item=product}
						<p>
						<a href="{$product.link_to_product}">{$product.quantity_in_cart} x {$product.name}</a>
						
						{if isset($product.options_text)}
							<br/>{$product.options_text}
						{/if}
						</p>
					{/foreach}
					</td>
					
					<td>{$cart.total_emails_sent}</td>
					
					<td>
						<form action="{$VAL_SELF}#current_abandoned_carts" method="post" enctype="multipart/form-data">
							<input type="hidden" name="token" value="{$SESSION_TOKEN}" />
							<input type="hidden" name="manual_send_abandoned_cart_email" value="{$cart.customer_id}" />
							<input type="submit" value="{$LANG.abandoned_carts.send_manual_email}" />
						</form>
					</td>
				</tr>
			{/foreach}
		{/if}	
		
		</tbody>
	</table>
</div>


<div id="install_guide" class="tab_content">
	<h3>{$LANG.abandoned_carts.install_guide}</h3>
	
	<p>Abandoned carts module allows you to try and cash in on missed opportunities. If a known customer leaves your store with items still in their basket the basket and does not return within {$MODULE.minutes_before_abandoned} (configurable) minutes the potential order is considered abandoned.</p>
	
	<p>this module is supported in CubeCart version 6.0.9 and higher. The module requires no edits to any core CubeCart files as it makes use of available hooks within the core CubeCart engine.</p>
	
	<p>This module can send emails to known customers who have abandoned an order either manually or automatically.</p>
	
	<p>When you first installed this module it created a new email template called &quot;Cart: Abandoned Cart&quot; which you can edit <a href="?_g=documents&node=email">here</a>. You can design your own e-mail content to suit your own needs or use the stock email content template. The module will try and send the email in the customers chosen language. It is recommended that you create an abandoned carts email template for each language you have in use.</p>
	
	<p>You can review any potential orders which are considered abandoned from the "Current Abandoned Carts" tab of the module. From this tab you can review the potential order and gather customer contact details. You can also review the overall value of the potential order and the products of interest. You can manually send the customer an email from this tab also. Manually sending an email will always send an additional email regardless of the total number of emails sent. </p>
	
	<p>The module has the following configurable settings</p>
	<ul>
	<li><strong>Send Automated Emails</strong><br/>When enabled the module will auto send e-mails to the customer if the cart is considered abandoned.</li>
	<li><strong>Number of minutes before a cart is considered abandoned</strong><br/>You don't want to bombard customers who are still shopping on your site with junk mail so you need to configure the amount of time in minutes that should pass before a cart is considered abandoned. Once this amount of time has passed the cart is considered abandoned. The default value for this setting is 60 minutes (1 hour).</li>
	<li><strong>Exclude abandoned carts older than this number of minutes</strong><br/>You do not want to keep reminding the same customer about their potential order if the cart was abandoned a long time ago. This setting defines the maximum age in minutes of an abandoned cart. Once the abandoned cart is older than this setting it will no longer be considered abandoned. The default value for this setting is 2880 minutes (48 hours).</li>
	<li><strong>Total number of emails to send</strong><br/>You may wish to send your customers more than one reminder email. You can define the maximum number of automated emails to send to the customer. The default value for this setting is 1</li>
	<li><strong>Number of minutes to wait before sending an additional email</strong><br/>If you are sending more than one e-mail to your customer you can define the minimum amount of time in minutes to wait between additional emails. The default value for this setting is 120 minutes (2 hours)</li>
	
	</ul>

</div>

<div id="stats" class="tab_content">
	<h3>{$LANG.abandoned_carts.stats}</h3>
	<p>The abandoned carts module gathers some basic stats about return customer rates and conversion into orders. When a customer clicks a link in an email to return to the store the click is recorded. If the customer then places an order it becomes tagged as converted from abandoned to confirmed. Below you can see your basic stats. If you do not see any stats below it is because no stats have yet been gathered. If the charts have not loaded correctly you may need to refresh the page (F5) to reload the data.</p>
	
	{if !empty($SENT_EMAIL_VS_RETURNED)}
		{literal}
		<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
		<script type="text/javascript">
		  google.charts.load('current', {'packages':['bar','corechart']});
		  google.charts.setOnLoadCallback(drawChart);
		  google.charts.setOnLoadCallback(drawChart1);
		  
		  function drawChart() {
			var data = google.visualization.arrayToDataTable([
			  ['Date', 'Emails Sent', 'Returned users by click', 'Converted Orders'],{/literal}

			  {foreach from=$SENT_EMAIL_VS_RETURNED item=stat}			  
				['{$stat.year} {$stat.month}', {$stat.emails_sent}, {$stat.customers_returned}, {$stat.converted_to_order}],
			  {/foreach}
				  
			  {literal}
			]);

			
			var options = {
			  chart: {
				title: 'Abandoned Carts Performance',
				subtitle: 'Live stats based upon sent emails, clicks within the emails and conversions to orders by date',
			  }
			};

			var chart = new google.charts.Bar(document.getElementById('columnchart_material'));
			chart.draw(data, options);
		  }
		  
		  function drawChart1() {
			var data = google.visualization.arrayToDataTable([
			  ['Date', 'Captured income with shipping', 'Captured income without shipping'],{/literal}
			  
			  {foreach from=$INCOME_FROM_ABANDONED_CARTS item=stats}
				['{$stats.year} {$stats.month}', {$stats.total_spend_with_shipping}, {$stats.total_spend_without_shipping}],			  
			  {/foreach}
			  {literal}
			]);

			var options = {
			  title: 'Sales Generated from Abandoned Cart email clicks',
			  curveType: 'function',
			  legend: { position: 'bottom' }
			};

			var chart = new google.visualization.LineChart(document.getElementById('curve_chart'));

			chart.draw(data, options);
		  }		  
		</script>

		{/literal}
	
		<br><br>
		<h3>{$LANG.abandoned_carts.click_through_stats}</h3>
		<div id="columnchart_material" style="width: 100%; height: 500px;"></div>
		
		{if !empty($ABANDONED_ORDERS)}

			<br><br>
			<h3>{$LANG.abandoned_carts.financial_stats}</h3>
			
			<div id="curve_chart" style="width:100%; height: 500px"></div>
		
			<br/><br/>
			<h3>{$LANG.abandoned_carts.converted_orders}</h3>
			
			
			<table style="width:100%;">
				<thead>
					<tr>
						<td>{$LANG.abandoned_carts.date}</td>
						<td>{$LANG.abandoned_carts.customer_name}</td>
						<td>{$LANG.abandoned_carts.order_number}</td>
						<td>{$LANG.abandoned_carts.subtotal}</td>
						<td>{$LANG.abandoned_carts.total_discount}</td>
						<td>{$LANG.abandoned_carts.shipping}</td>
						<td>{$LANG.abandoned_carts.total_tax}</td>
						<td>{$LANG.abandoned_carts.total}</td>
					</tr>
				</thead>
				
				<tbody>
					{foreach from=$ABANDONED_ORDERS item=order}
						<tr>
						<td>{$order.order_date}</td>
						<td><a href="?_g=customers&action=edit&customer_id={$order.customer_id}">{$order.customer_name}</a></td>
						<td><a href="?_g=orders&action=edit&order_id={$order.cart_order_id}">{$order.cart_order_id}</a></td>
						<td>{$order.subtotal}</td>
						<td>{$order.discount}</td>
						<td>{$order.shipping}</td>
						<td>{$order.total_tax}</td>
						<td>{$order.total}</td>
						</tr>
					{/foreach}
					
					<tr>
						<td colspan="3"></td>
						<td>{$ABANDONED_ORDERS_TOTALS.subtotal}</td>
						<td>{$ABANDONED_ORDERS_TOTALS.discount}</td>
						<td>{$ABANDONED_ORDERS_TOTALS.shipping}</td>
						<td>{$ABANDONED_ORDERS_TOTALS.total_tax}</td>
						<td>{$ABANDONED_ORDERS_TOTALS.total}</td>
					</tr>
				</tbody>
			</table>
		{/if}

	{/if}


	

	
	
	
	
	
</div>
