function absolute_matrix_price_calc(){
	
	//var thisOptionID = $(this).attr('absoluteOptions');
	//var thisValueID = $("#option_"+thisOptionID).val();
	var optionString = "";
	var totalOptionGroups = 0;

	// So we know how many options are using our module
	$('select[absoluteOptions]').each(function() {
		totalOptionGroups ++;
	});		
	
	// Only carry on IF we have some options that use our module
	if(totalOptionGroups > 0){
		
		// Init the array 
		var optionGroupArray = [];
		
		// Build an array of all option ID's
		$('select[absoluteOptions]').each(function() {
			optionGroupArray.push($(this).attr('absoluteOptions'));
		});
		
		// Sort the option ID array
		optionGroupArray.sort();		

		// Loop the option ID array and get the values
		var i;
		for (i = 0; i < optionGroupArray.length; ++i) {
			// optionID = optionGroupArray[i];
			optionString += optionGroupArray[i] + $("#option_"+optionGroupArray[i]).val();
		}
		
		// Price Exists?
		if(optionString in absoluteDefinedPrices){
			var action = $('form.add_to_basket').attr('action');
			var parts = action.split("?");
			
			if (parts.length > 1) {
				action += "&";
			} else {
				action += "?";
			}
			action += '_g=ajax_price_format&price[0]=';				
			
			$.ajax({
				url: action + absoluteDefinedPrices[optionString],
				cache: true,
				complete: function(returned) {
					var prices = $.parseJSON(returned.responseText);
					$('#ptp').html(prices[0]);
				}
			});				
		}
		
		// Product Code Exists?
		if(optionString in absoluteProductCodes){
			$('#absoluteMatrixPriceProductCode').html(absoluteProductCodes[optionString]);
		}else{
			$('#absoluteMatrixPriceProductCode').html(absoluteProductCodes['parent_product_code']);
		}
		
		// Stock levels exist?
		if(optionString in absoluteStockLevels){
			$('#absoluteMatrixStockLevel').html(absoluteStockLevels[optionString]);
			$('#addToBasketButton').removeClass("hide");
		}else{
			$('#absoluteMatrixStockLevel').html('0');
			$('#addToBasketButton').addClass("hide");
		}
		
		
	}
}

$( document ).ready(function() {
	$('select[absoluteOptions]').change(function() {
		absolute_matrix_price_calc();
	});
});