<div id="{$PLUGIN_NAME}" class="tab_content">
	<form action="{$VAL_SELF}" method="post" enctype="multipart/form-data">
	<h3>{$PLUGIN_TITLE}</h3>

	<fieldset><legend>Configuration Settings</legend>
		<div><label for="status">{$LANG.common.status}</label><span><input type="hidden" name="module[status]" id="status" class="toggle" value="{$MODULE.status}" />&nbsp;</span></div>
	</fieldset>

	<fieldset><legend>License Settings</legend>
		<div><label for="ndl_license_key">License Key</label><span><input name="module[ndl_license_key]" id="ndl_license_key" class="textbox" type="text" value="{$PLUGIN_LICENSE_KEY}" /></span></div>

		{$PLUGIN_LICENSE_STATUS}
		{$PLUGIN_SUPPORT_STATUS}
		{if isset($PLUGIN_SUPPORT_ENDS)}
			{$PLUGIN_SUPPORT_ENDS}	
		{/if}
		
		<input type="hidden" name="module[general_tab]" value="general_tab">
	</fieldset>

	<fieldset><legend>Plugin Version Information & Messages</legend>
		<div>Version: {$PLUGIN_VERSION} </div>
		{if isset($PLUGIN_MESSAGES)}
			{$PLUGIN_MESSAGES}
		{/if}
	</fieldset>	
	
	<fieldset><legend>Important Information</legend>
		<p>This plugin enhances the way in which CubeCart matrix product options work, it does not replace it.  The vast majority of the enhancements are contained within the plugin although there are some changes which need to be made within your store skin. Within the install guide there are several sample skin changes which are based on the CubeCart 6 foundation skin. The sample skin changes can be modified to suit your own requirements however it does require an understanding of how CubeCart smarty templates work. If you are unfamiliar with editing CubeCart skins and you have a custom requirement please reach out to support who may be able to help build what you need.</p> 
		<p>The sample skin changes include a modification to the product page which adds a new tab called &quot;Product Options&quot;. When you click on this tab a list of all option combinations that exist within the option matrix is displayed. Your customers can directly add products to their basket from this page. You can choose to hide out of stock options from this table by checking the "hide out of stock" which is found within the option matrix settings for the selected product. Please note that the hide out of stock option <b>ONLY</b> works with the custom product option table, <b>It does not hide items from the standard CubeCart option selection menus</b>.</p>
		<p>There are also some sample skin changes which add an informative table to the product page, in my example within the install guide this is added between the price and the add to basket button. The table contains the product code and stock level. The product code and stock level will dynamically update once the customer has selected a valid combination of options which can be found in the matrix. It is possible to hide the add to basket button if the customer selects an out of stock matrix item, assuming you are using stock levels. This table is only an example of what can be done with the plugin and you do not have to use it. The skin samples can be modified to suit your own needs.</p>
		<p>It is highly recommended that any product options you add to the matrix are &quot;required&quot; options. Making them required will always ensure that the customer has to select a valid option matrix combination before they can add the product to their cart.</p>
		<p>The plugin also allows you to define absolute prices for matrix items. You can enable an absolute price for any number of matrix options. When using matrix absolute prices you should not use the standard CubeCart option price addition and subtraction processes or use the standard CubeCart absolute prices feature.</p>
		<p>Within the foundation skin the product price dynamically updates each time a customer selects a new option. This plugin enhances the standard process by adding it's own price update functionality. If the customer has selected a valid combination of matrix product options and the matrix option is using an absolute price then the price displayed to the customer will be updated. Sale prices are not supported.</p>
	</fieldset>
	
	<fieldset><legend>Smarty Objects</legend>
		<p>The plugin sends a variety of smarty objects to the product page. A list of the main objects and some non standard fields is below</p>
		<div><label for="smarty1">{literal}{$ABSOLUTE_MATRIX_OPTIONS}{/literal}</label><span>An array of all valid matrix options. This needs to be looped using a foreach statement. some of the non standard fields are described below</span></div>
		<div><label for="smarty2">{literal}{$ABSOLUTE_MATRIX_OPTIONS} -> parent_product_code{/literal}</label><span>The product code of the main product instead of an option.</span></div>
		<div><label for="smarty3">{literal}{$ABSOLUTE_MATRIX_OPTIONS} -> option_name{/literal}</label><span>A string containing the cached option names.</span></div>
		<div><label for="smarty4">{literal}{$ABSOLUTE_MATRIX_OPTIONS} -> option_name_formated_1{/literal}</label><span>A string containing the cached option names in an alternative format.</span></div>
		<div><label for="smarty6">{literal}{$ABSOLUTE_MATRIX_OPTIONS} -> use_absolute_price{/literal}</label><span>A 1 or 0 flag. 1 means use an absolute price.</span></div>
		<div><label for="smarty7">{literal}{$ABSOLUTE_MATRIX_OPTIONS} -> absolute_option_price{/literal}</label><span>The absolute price of the matrix option.</span></div>
		<div><label for="smarty8">{literal}{$ABSOLUTE_MATRIX_OPTIONS} -> hide_out_of_stock{/literal}</label><span>a 1 or 0 flag. 1 means hide the out of stock matrix option.</span></div>
		<div><label for="smarty9">{literal}{$ABSOLUTE_MATRIX_OPTIONS} -> price_formatted{/literal}</label><span>The option price formatted.</span></div>
		<div><label for="smarty10">{literal}{$ABSOLUTE_OPTIONS_GROUPS}{/literal}</label><span>Returns false if empty. Contains an array of all option_id values which are included in the option matrix. This objects needs to be looped using a foreach statement</span></div>
		<div><label for="smarty11">{literal}{$ABSOLUTE_OPTIONS_PRICES}{/literal}</label><span>Returns false if empty. Contains an array of all prices for matrix items. This objects needs to be looped using a foreach statement</span></div>
		<div><label for="smarty12">{literal}{$ABSOLUTE_OPTIONS_PRICES_STRING}{/literal}</label><span>Returns false if empty. Contains an array of all prices for matrix items in a jQuery object format. This should be included on the product page as it makes information available to the custom javascript functions.</span></div>
		<div><label for="smarty13">{literal}{$ABSOLUTE_OPTIONS_PRODUCT_CODES}{/literal}</label><span>Returns false if empty. Contains an array of all product codes for matrix items in a jQuery object format. This should be included on the product page as it makes information available to the custom javascript functions.</span></div>
		<div><label for="smarty14">{literal}{$ABSOLUTE_OPTIONS_STOCK_LEVELS}{/literal}</label><span>Returns false if empty. Contains an array of all stock levels for matrix items in a jQuery object format. This should be included on the product page as it makes information available to the custom javascript functions.</span></div>
	</fieldset>	
	
	<div class="form_control">
	<input type="submit" value="{$LANG.common.save}" />
	</div>
	<input type="hidden" name="token" value="{$SESSION_TOKEN}" />
	</form>
</div>

<div id="install_guide" class="tab_content">
	<h3>{$LANG.absolute_option_matrix_prices.install_guide}</h3>
	<p>{$LANG.absolute_option_matrix_prices.install_guide_desc}</p>
	
	<ol>
		<li>
			<p><span style="font-weight:bold; color:red;">REQUIRED CHANGE: </span>This first change adds some extra columns to the product option matrix edit screen.<p>
			<p>open file &quot;/admin/skins/default/templates/products.index.php&quot; with your favourite text editor. Around line number 511 FIND:<p>
			<textarea style="width:100%; height:30px;">{literal}<th>{$LANG.catalogue.restock_note}</th>{/literal}</textarea>
			<p>AFTER ON A NEW LINE ADD:<p>
			<textarea style="width:100%; height:50px;">{literal}<th>{$LANG.absolute_option_matrix_prices.use_absolute_price}</th>
<th>{$LANG.absolute_option_matrix_prices.price}</th>
<th>{$LANG.absolute_option_matrix_prices.hide_out_of_stock}</th>{/literal}</textarea>
			<br/><br/><br/>
			<p><span style="font-weight:bold; color:red;">REQUIRED CHANGE: </span>Around line number 527 FIND:<p>
			<textarea style="width:100%; height:30px;">{literal}<td><input type="text" name="option_matrix[{$row.options_identifier}][restock_note]" class="textbox number" value="{$OPTIONS_MATRIX.existing.{$row.options_identifier}.restock_note}" maxlength="255" ></td>{/literal}</textarea>
			<p>AFTER ON A NEW LINE ADD:<p>
			<textarea style="width:100%; height:75px;">{literal}<td align="center"><input type="hidden" id="use_absolute_price_{$row.options_identifier}" name="option_matrix[{$row.options_identifier}][use_absolute_price]" value="{$OPTIONS_MATRIX.existing.{$row.options_identifier}.use_absolute_price}" class="toggle"></td>
<td><input type="text" name="option_matrix[{$row.options_identifier}][absolute_option_price]" class="textbox number" value="{$OPTIONS_MATRIX.existing.{$row.options_identifier}.absolute_option_price}"></td>
<td align="center"><input type="hidden" id="hide_out_of_stock_{$row.options_identifier}" name="option_matrix[{$row.options_identifier}][hide_out_of_stock]" value="{$OPTIONS_MATRIX.existing.{$row.options_identifier}.hide_out_of_stock}" class="toggle"></td>{/literal}</textarea>			
		</li>
		
		<br/><br/>
		
		
		<li>
		<p><span style="font-weight:bold; color:red;">REQUIRED CHANGE IF USING 6.0.10 OR LOWER: </span> This step adds a custom hook which allows the plugin to override prices. You do not need to complete this step if you are using CubeCart 6.0.11 or higher.<p>
		<p>open file &quot;/classes/cart.class.php&quot; with your favourite text editor. Around line number 642 FIND:<p>
		<textarea style="width:100%; height:30px;">{literal}$product = $GLOBALS['catalogue']->getProductData($item['id'], $item['quantity'], false, 10, 1, false, $item['options_identifier']);{/literal}</textarea>
		<p>AFTER ON A NEW LINE ADD:<p>
		<textarea style="width:100%; height:30px;">{literal}foreach ($GLOBALS['hooks']->load('class.cart.get.product_prices') as $hook) include $hook;{/literal}</textarea>
		</li>
		
		
		<br/><br/>
		
		<li>
		<p><span style="font-weight:bold; color:red;">REQUIRED CHANGE: </span> This change adds required script objects to the product page.<p>
		<p>open file &quot;/skins/foundation/templates/content.product.php&quot; with your favourite text editor. Around line number 14 FIND:<p>
		<textarea style="width:100%; height:30px;">{literal}<form action="{$VAL_SELF}" method="post" class="add_to_basket">{/literal}</textarea>
		<p>AFTER ON A NEW LINE ADD:<p>
		<textarea style="width:100%; height:300px;">{literal}
{if isset($ABSOLUTE_MATRIX_OPTIONS) && is_array($ABSOLUTE_MATRIX_OPTIONS)}
	{if isset($ABSOLUTE_OPTIONS_PRICES) && $ABSOLUTE_OPTIONS_PRICES != false}
		<script>
		var absoluteDefinedPrices = {$ABSOLUTE_OPTIONS_PRICES_STRING}
		</script>
	{/if}
	{if isset($ABSOLUTE_OPTIONS_PRODUCT_CODES) && $ABSOLUTE_OPTIONS_PRODUCT_CODES != false}
		<script>
		var absoluteProductCodes = {$ABSOLUTE_OPTIONS_PRODUCT_CODES}
		</script>
	{/if}			
	{if isset($ABSOLUTE_OPTIONS_STOCK_LEVELS) && $ABSOLUTE_OPTIONS_STOCK_LEVELS != false}
		<script>
		var absoluteStockLevels = {$ABSOLUTE_OPTIONS_STOCK_LEVELS}
		</script>
	{/if}	
{/if}		
		{/literal}</textarea>		
		
		
		</li>
		
		<br/><br/>
		
		<li>
		<p><span style="font-weight:bold; color:red;">REQUIRED CHANGE: </span> This change makes the CubeCart price update process hook into the plugins custom price update process. Without this steps prices may not always dynamically update on the product page.<p>
		<p>open file &quot;/skins/founation/js/2.cubecart.js&quot; with your favourite text editor. Around line number 377 FIND:<p>
		<textarea style="width:100%; height:200px;">{literal}
} else {
	$.ajax({
		url: action + ptp,
		cache: true,
		complete: function(returned) {
			var prices = $.parseJSON(returned.responseText);
			$('#ptp').html(prices[0]);
		}
	});
}				
		{/literal}</textarea>
		<p>AFTER ON A NEW LINE ADD:<p>
		<textarea style="width:100%; height:30px;">{literal}absolute_matrix_price_calc();{/literal}</textarea>

		</li>
		
		<br/><br/>
		
		<li>
		<p><span style="font-weight:bold; color:red;">REQUIRED CHANGE: </span> This change ensures the plugin can correctly identify which options on the product page belong to matrix options.<p>
		<p>open file &quot;/skins/foundation/templates/content.product.php&quot; with your favourite text editor. Around line number 67 FIND:<p>
		<textarea style="width:100%; height:60px;">{literal}<select name="productOptions[{$option.option_id}]" id="option_{$option.option_id}" class="nomarg" {if $option.required}required{/if}>{/literal}</textarea>
		<p>REPLACE WITH:<p>
		<textarea style="width:100%; height:60px;">{literal}<select name="productOptions[{$option.option_id}]" id="option_{$option.option_id}" class="nomarg" {if $option.required}required{/if} {if isset($ABSOLUTE_OPTIONS_GROUPS) && (in_array($option.option_id, $ABSOLUTE_OPTIONS_GROUPS))}absoluteOptions="{$option.option_id}"{/if}>{/literal}</textarea>
		
		
		</li>
		
		<br/><br/>
		
		<li>
			<p><span style="font-weight:bold; color:blue;">CODE SAMPLE: </span>This next change is optional, it depends on how you want to use the plugin. This step is an example on how to add matrix options as a table to your product page. This example has been written to work with the foundation skin. It will work with other skins but you may need to adjust the code.<p>
			<p>open file &quot;/skins/foundation/templates/content.product.php&quot; with your favourite text editor. Around line number 146 FIND:<p>
			<textarea style="width:100%; height:60px;">{literal}{if isset($PRODUCT.discounts)}
<dd><a href="#quantity_discounts">{$LANG.catalogue.quantity_discounts}</a></dd>
{/if}{/literal}</textarea>
			<p>AFTER ON A NEW LINE ADD:<p>			
			<textarea style="width:100%; height:60px;">{literal}{if isset($ABSOLUTE_MATRIX_OPTIONS) && is_array($ABSOLUTE_MATRIX_OPTIONS)}
<dd class="active"><a href="#absolute_options">Product Options</a></dd>
{/if}{/literal}</textarea>			
			<br/><br/><br/>
			<p>Around line number 152 FIND:<p>
			<textarea style="width:100%; height:30px;">{literal}<div class="tabs-content">{/literal}</textarea>
			<p>AFTER ON A NEW LINE ADD:<p>
			<textarea style="width:100%; height:1250px;">{literal}
{if isset($ABSOLUTE_MATRIX_OPTIONS) && is_array($ABSOLUTE_MATRIX_OPTIONS)}
	</form>
	<div class="content" id="absolute_options">
		<table class="price-list-table" id="price-list-table" style="width:100%;">
			<thead>
				<tr>
					<td>{$LANG.absolute_option_matrix_prices.code}</td>
					<td>{$LANG.absolute_option_matrix_prices.option}</td>
					<td>{$LANG.absolute_option_matrix_prices.price}</td>
					<td>{$LANG.absolute_option_matrix_prices.in_stock}</td>
					<td class="text-center">{$LANG.absolute_option_matrix_prices.qty}</td>
					<td>&nbsp;</td>
				</tr>
			</thead>	
			
			<tbody class="reorder-list ui-sortable">
				{foreach from=$ABSOLUTE_MATRIX_OPTIONS key=my_key item=p}
					{if ($p.hide_out_of_stock == 0) || ($p.hide_out_of_stock == 1 && $p.use_stock == 1 && $p.stock_level > 0)}
						<tr>
							<form action="{$VAL_SELF}" class="add_to_basket" method="post">
							<td>{$p.product_code}</td>
							<td>{$p.option_name_formated_1}</td>
							<td>{$p.price_formatted}</td>
							<td class="text-center">{$p.stock_level}</td>
							<td><input class="quantity checkout" type="text" value="1" name="quantity"></td>
							<td>
								<input name="add" type="hidden" value="{$p.product_id}"> 
								
								{if isset($p.assign_id1)}
									<input type="hidden" name="productOptions[{$p.option_id1}]" id="option_{$p.option_id1}" value="{$p.assign_id1}">
								{/if}

								{if isset($p.assign_id2)}
									<input type="hidden" name="productOptions[{$p.option_id2}]" id="option_{$p.option_id2}" value="{$p.assign_id2}">
								{/if}						

								{if isset($p.assign_id3)}
									<input type="hidden" name="productOptions[{$p.option_id3}]" id="option_{$p.option_id3}" value="{$p.assign_id3}">
								{/if}												

								{if isset($p.assign_id4)}
									<input type="hidden" name="productOptions[{$p.option_id4}]" id="option_{$p.option_id4}" value="{$p.assign_id4}">
								{/if}																		

								{if isset($p.assign_id5)}
									<input type="hidden" name="productOptions[{$p.option_id5}]" id="option_{$p.option_id5}" value="{$p.assign_id5}">
								{/if}

								{if isset($p.assign_id6)}
									<input type="hidden" name="productOptions[{$p.option_id6}]" id="option_{$p.option_id6}" value="{$p.assign_id6}">
								{/if}

								{if isset($p.assign_id7)}
									<input type="hidden" name="productOptions[{$p.option_id7}]" id="option_{$p.option_id7}" value="{$p.assign_id7}">
								{/if}

								{if isset($p.assign_id8)}
									<input type="hidden" name="productOptions[{$p.option_id8}]" id="option_{$p.option_id8}" value="{$p.assign_id8}">
								{/if}

								{if isset($p.assign_id9)}
									<input type="hidden" name="productOptions[{$p.option_id9}]" id="option_{$p.option_id9}" value="{$p.assign_id9}">
								{/if}

								{if isset($p.assign_id10)}
									<input type="hidden" name="productOptions[{$p.option_id10}]" id="option_{$p.option_id10}" value="{$p.assign_id10}">
								{/if}
								<button class="button postfix" type="submit" value="{$LANG.catalogue.add_to_basket}">{$LANG.catalogue.add_to_basket}</button>
							</td>
							</form>
						</tr>
					{/if}
				{/foreach}
			</tbody>
		</table>
	</div>	
{/if}
			{/literal}</textarea>
		</li>
		
		<br/><br/>
		
		<li>
			<p><span style="font-weight:bold; color:blue;">CODE SAMPLE: </span>This next change is optional, it depends on how you want to use the plugin. This step is an example on how to add a table between the price and add to basket button which displays the product code and stock level. The product code and stock level dynamically update when the customer selects a valid combination of options.<p>
			<p>open file &quot;/skins/foundation/templates/content.product.php&quot; with your favourite text editor. Around line number 111 FIND:<p>
			<textarea style="width:100%; height:70px;">{literal}
   <span id="ptp"{if !$CTRL_HIDE_PRICES} data-price="{$PRODUCT.price_to_pay}"{/if}>{$PRODUCT.price}</span>
   {/if}
</h3>
{/literal}</textarea>
			<p>AFTER ON A NEW LINE ADD:<p>
			<textarea style="width:100%; height:250px;">{literal}
{if isset($ABSOLUTE_MATRIX_OPTIONS) && is_array($ABSOLUTE_MATRIX_OPTIONS)}
	<table style="width:100%;">
		<tbody>
			<tr>
				<td>{$LANG.catalogue.product_code}</td>
				<td><span id="absoluteMatrixPriceProductCode">{$PRODUCT.product_code}</span></td>
			</tr>
			<tr>
				<td>{$LANG.catalogue.stock_level}</td>
				<td><span id="absoluteMatrixStockLevel"></span></td>
			</tr>
		</tbody>
	</table>
{/if}	
{/literal}</textarea>			
		</li>
		
		<br/><br/>
		
		<li>
			<p><span style="font-weight:bold; color:blue;">CODE SAMPLE: </span>This next change is optional, it depends on how you want to use the plugin. This steps allows you to hide the add to basket button if the customer selects a combination of options that is currently out of stock.<p>
			<p>open file &quot;/skins/foundation/templates/content.product.php&quot; with your favourite text editor. Around line number 162 FIND:<p>
			<textarea style="width:100%; height:70px;">{literal}
<div  class="small-12 medium-10 columns">
  <button type="submit" value="{$LANG.catalogue.add_to_basket}" class="button postfix">{$LANG.catalogue.add_to_basket}</button>
</div>
{/literal}</textarea>			
		<p>REPLACE WITH:<p>
			<textarea style="width:100%; height:70px;">{literal}
<div  class="small-12 medium-10 columns" id="addToBasketButton">
  <button type="submit" value="{$LANG.catalogue.add_to_basket}" class="button postfix">{$LANG.catalogue.add_to_basket}</button>
</div>
{/literal}</textarea>			
		</li>
		
		
		
	</ol>
</div>