<form action="{$VAL_SELF}" method="post" enctype="multipart/form-data">
  <div id="ebay_orders" class="tab_content">
	<h3>Import From Ebay</h3>
	<p>Noodlemans Ebay Orders plugin allows you to import your ebay customers & orders into CubeCart & update ebay from a central location. It is an easy way to manage your orders and inventory when selling on ebay and when combined with the Ebay Sales plugin.</h3></p>

	<fieldset><legend>Configuration Settings</legend>
		<div><label for="status">{$LANG.common.status}</label><span><input type="hidden" name="module[status]" id="status" class="toggle" value="{$MODULE.status}" />&nbsp;</span></div>
	</fieldset>
	
	
	<fieldset><legend>License Information</legend>
		{$PLUGIN_LICENSE_KEY_HTML}
		{$PLUGIN_LICENSE_STATUS}
		{$PLUGIN_SUPPORT_STATUS}
		{if isset($PLUGIN_SUPPORT_ENDS)}
			{$PLUGIN_SUPPORT_ENDS}	
		{/if}
	</fieldset>
	
	{if isset($DEBUG_MEMORY_START)}
		<fieldset><legend>Memory Debug Info</legend>
		{$DEBUG_MEMORY_START}
		{$DEBUG_MEMORY_END}
		</fieldset>
	{/if}
	
	<fieldset><legend>{$LANG.ebay_orders.ebay_get_orders}</legend>
		<a href="{$EBAY_GET_ORDERS_LINK}">Get Latest Orders</a>
	</fieldset>	
	<br/>
	<fieldset><legend>{$LANG.ebay_orders.ebay_settings1}</legend>
		<b>{$LANG.ebay_orders.ebay_session_s}</b><br/>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{$EBAY_SESSION}
		<br/>
		<b>{$LANG.ebay_orders.ebay_token_s}</b><br/>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{$EBAY_TOKEN}<br/>
		<b>{$LANG.ebay_orders.ebay_token_e}</b><br/>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{$EBAY_TOKEN_EXPIRES}<br/>	
		<b>{$LANG.ebay_orders.ebay_api_m}</b><br/>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{if isset($EBAY_API_MESSAGE)}
			{$EBAY_API_MESSAGE}
		{/if}
		
		<br/>
	</fieldset>		
	
	<fieldset>
		<legend>Ebay Orders Configuration</legend>
			<div>
				<label for="auto_update_mappings">Auto Update Mappings</label>
				<span>
				<select name="module[auto_update_mappings]" original="sandbox">
					<option value="0" {if $AUTO_UPDATE_MAPPINGS == 0}selected{/if}>Off</option>
					<option value="1" {if $AUTO_UPDATE_MAPPINGS == 1}selected{/if}>On (Updated with every get order attempt)</option>
					<option value="2" {if $AUTO_UPDATE_MAPPINGS == 2}selected{/if}>On (Updated after Ebay Sales has pushed listings - RECOMMENDED)</option>
				</select>
				</span>
			</div>

			<div>
				<label for="cleanup_customers">Only Import Customer Accounts with valid orders</label><span><input type="hidden" name="module[cleanup_customers]" id="cleanup_customers" class="toggle" value="{$MODULE.cleanup_customers}" />&nbsp;</span>
			</div>			
			
			<div>
				<label for="auto_leave_feedback">Leave Feedback</label><span><input type="hidden" name="module[auto_leave_feedback]" id="auto_leave_feedback" class="toggle" value="{$MODULE.auto_leave_feedback}" />&nbsp;</span>
			</div>

			<div>
				<label for="enable_random_email">Enable Random Email addresses for imported customers</label><span><input type="hidden" name="module[enable_random_email]" id="enable_random_email" class="toggle" value="{$MODULE.enable_random_email}" />&nbsp;</span>
			</div>

			<div>
				<label for="random_email_domain">Random email domain</label><span><input type="text" name="module[random_email_domain]" id="random_email_domain" class="textbox" value="{$MODULE.random_email_domain}" placeholder="@yourdomain.com" />&nbsp;</span>
			</div>
			
	</fieldset>
	
	
	<br/>		
	
	{$EBAY_ORDERS_GENERAL_TAB}


	<div class="form_control">
		<input type="submit" name="save" value="{$LANG.common.save}" />
	</div>

	<br/>
	
	
	<fieldset><legend>{$LANG.ebay_orders.ebay_buttons}</legend>
		<a href="{$EBAY_SESSION_LINK}">Link Ebay Account (Get Session)</a> &nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp; <a href="{$EBAY_TOKEN_LINK}">Link Ebay Account (Get Token)</a>
	</fieldset>

	<fieldset><legend>Plugin Version Information & Messages</legend>
		<div>Version: {$EBAY_ORDERS_PLUGIN_VERSION} </div>
		{$EBAY_ORDERS_MESSAGES}
	</fieldset>
	
	<fieldset><legend>{$LANG.ebay_orders.ebay_notes}</legend>
		<p>This plugin can be used free of charge without a valid license, however only the most basic features of the plugin will function without a license. The free version allows you to:
			<ul>
				<li>Import customers from ebay sales</li>
				<li>Import non variation orders from ebay without inventory control</li>
			</ul>

		<p>Having a valid license unlocks the following features of this plugin.</p>
			
			<ul>
				<li>CubeCart inventory levels are reduced by the quantity of the ebay sale (Including Matrix items if product code is defined and listing was created using the ebay sales plugin)</li>
				<li>CubeCart & Ebay variation listings are supported (When Variation listings have been sent to Ebay using the Ebay Sales plugin & when matrix items have product codes)</li>
				<li>Ebay to CubeCart mappings will auto update frequently and will auto match to CubeCart inventory items where possible (including variations/matrix items if ebay sales plugin was used to send inventory to ebay)</li>
				<li>Orders will auto import from ebay when viewing your order list, no need to manually import orders</li>
				<li>When marking an imported order as Completed in CubeCart, the sold ebay item will be updated as Dispatched & Tracking information added if available</li>
				<li>When marking an imported order as Completed in CubeCart, the ebay buyer will have positive feedback left for them</li>
				<li>When marking an imported order as Completed in CubeCart, send an optional message to the buyer</li>
			</ul>
		</p>
		
		
		<p>To get started you need to do the following
			<ol>
			<li>Register for an account on the eBay developer network. you can do this <a href="https://www.x.com/developers/ebay">here</a>.</li>
			<li>Generate a set of production API Keys, this will give you the AppID, DevID and CertID required in the above configuration. This is done from your eBay developer account.</li>
			<li>Create a production RuName (Application). This is done from your eBay developer account.</li>
			<li>Put your RuName, AppID, DevID and CerID from the ebay developer network into the plugin configuration</li>
			<li>Set the maximum age of orders to import. This is set in seconds and defaults to 7 days. Press save when done.</li>
			<li>Click the "Link ebay account" link. You will need to have popups enabled. a new window opens and you log in using your ebay account and accept the usage policy. Close the window after accepting</li>
			<li>Click the "Link Ebay Account" link. This will link the plugin to the ebay session you just accepted the policy against.</li>
			<li>Go to the product mapping tab and press the "Update Mapping Database" link. This will pull your active ebay listings into cubecart. After the import, update the records so they are mapped to your store product. Note, if you relist the same items frequently the plugin will auto populate the mapping to the store product for you based on past mapping values.</li>
			<li>When your mappings are up to date, go to the General tab and press the "Get Latest Orders" link. This will import your ebay orders and customers.</li>
			</ol>
		</p>
		
		<p>Once you have your ebay account linked, you don't need to change any more config. Simply keep your mappings up to date, and use the "get Latest Orders" link frequently or purchase a license and it will auto import & update for you</p>
			
		<p>A license can be purchased from <a href="http://www.noodleman.co.uk/">http://www.noodleman.co.uk/</a></p>
		<p>Support & Maintenance only applies if you have purchased a license</p>
	</fieldset>



  <input type="hidden" name="token" value="{$SESSION_TOKEN}" />	
	
  </div>
  {$MODULE_ZONES}
  

</form>

	  
<div id="mapping" class="tab_content">

	{$UPDATE_MAPPING_TABLE}

  <div class="form_control">
	<input type="submit" name="save" value="{$LANG.common.save}" />
  </div>
  <input type="hidden" name="token" value="{$SESSION_TOKEN}" />
	</form>

</div>


<div id="action_log" class="tab_content">
	{$ACTION_LOG}
</div>



{if isset($VARIATION_MAPPINGS)}
	{$VARIATION_MAPPINGS}
{/if}



<div id="feedback" class="tab_content">
	<p>{$FEEDBACK_SETTINGS_TAB}</p>


  <input type="hidden" name="token" value="{$SESSION_TOKEN}" />
	
	</form>

</div>


<div id="error_log" class="tab_content">
	{$EBAY_ORDERS_ERROR_LOG}
</div>

