<?php
// Debug
//error_reporting(E_ALL);
//ini_set("display_errors", 1);

/*
#######################
# 	SETUP CUBECART    #
#######################
*/
$_SERVER['SERVER_PORT'] = 443;
$_SERVER['SERVER_NAME'] = 'ebaySalesProcessor';

$store_document_root = str_replace("/modules/plugins/ebay_sales/cron", "", dirname(__FILE__));

require_once($store_document_root . "/ini.inc.php");
require_once($store_document_root . '/includes/global.inc.php');
define('ADMIN_CP', false);
require_once($store_document_root . '/includes/functions.inc.php');

define('CC_IN_ADMIN', false);

// Initialize Cache
$GLOBALS['cache'] = Cache::getInstance();
// Initialise Database class, and fetch default configuration
$GLOBALS['db'] = Database::getInstance($glob);
// Initialise Config class
$GLOBALS['config'] = Config::getInstance($glob);

//define('CC_STORE_URL', $GLOBALS['config']->get('config', 'standard_url'));
$GLOBALS['storeURL'] = $GLOBALS['config']->get('config', 'standard_url');

// Override the standard URL, because we are in a CRON job it will ALWAYS be "http" without this step...
if($GLOBALS['config']->get('config', 'ssl') != false){
    $GLOBALS['storeURL'] = str_replace("http://", "https://", $GLOBALS['storeURL']);
}

$GLOBALS['config']->merge('config', '', $config_default);
// Initialize debug
$GLOBALS['debug'] = Debug::getInstance();

//Initialize sessions
$GLOBALS['session'] = Session::getInstance();

//Initialize Smarty
$GLOBALS['smarty'] = new Smarty();
$GLOBALS['smarty']->muteExpectedErrors();
$GLOBALS['smarty']->error_reporting = E_ALL & ~E_NOTICE & ~E_WARNING;
$GLOBALS['smarty']->compile_dir  = CC_SKIN_CACHE_DIR;
$GLOBALS['smarty']->config_dir   = CC_SKIN_CACHE_DIR;
$GLOBALS['smarty']->cache_dir    = CC_SKIN_CACHE_DIR;
$GLOBALS['smarty']->debugging = false;

//Initialize language
$GLOBALS['language'] = Language::getInstance();

//Initialize hooks
$GLOBALS['hooks'] = HookLoader::getInstance();

//Initialize SEO
$GLOBALS['seo'] = SEO::getInstance();

//Initialize GUI
$GLOBALS['gui'] = GUI::getInstance();

//Initialize Taxes
$GLOBALS['tax'] = Tax::getInstance();
//Initialize catalogue
$GLOBALS['catalogue'] = Catalogue::getInstance();

//###################################
//# 	Error Log		HTML		#
//###################################

// Delete any old error log data, older than 5 days
$sql = "DELETE FROM plugin_ebay_sales_error_log WHERE unixts < " . (time() - 432000);
$query = $GLOBALS['db']->query($sql, false, 0, false);

//####################
//#   FUNCTIONS 	 #
//####################
include_once($store_document_root . '/modules/plugins/ebay_sales/admin/functions.php');

es_cronSync();

