<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
<link href="{$STORE_URL}/modules/plugins/ebay_sales/js/chosen_v1.8.7/chosen.css" rel="stylesheet"></script>
<script src="{$STORE_URL}/modules/plugins/ebay_sales/js/chosen_v1.8.7/chosen.jquery.min.js" type="text/javascript"></script>

<style>
	.chosen-container.chosen-container-single{
		width: 300px !important; /* or any value that fits your needs */
	}
	.chosen-container.chosen-container-multi {
		width: 300px !important; /* or any value that fits your needs */
	}
</style>


	<div id="ebay_sales" class="tab_content">
	  <form action="{$VAL_SELF}" method="post" enctype="multipart/form-data">
	<h3>{$LANG.ebay_sales.module_title}</h3>
	<p>{$LANG.ebay_sales.module_description}</p>

	<fieldset><legend>Configuration Settings</legend>
		<div><label for="status">{$LANG.common.status}</label><span><input type="hidden" name="module[status]" id="status" class="toggle" value="{$MODULE.status}" />&nbsp;</span></div>
	</fieldset>


	<fieldset><legend>License Information</legend>
		{$PLUGIN_LICENSE_KEY_HTML}
		{$PLUGIN_LICENSE_STATUS}
		{$PLUGIN_SUPPORT_STATUS}
		{if isset($PLUGIN_SUPPORT_ENDS)}
			{$PLUGIN_SUPPORT_ENDS}
		{/if}
	</fieldset>


	  <fieldset><legend>{$LANG.ebay_sales.ebay_settings1}</legend>
		  <div><label for="ebay_prod_username">Ebay Username</label><span><input name="esmodule[ebay_prod_username]" id="ebay_prod_username" class="textbox" type="text" value="{$SETTINGS_EBAY_USERNAME}" /></span></div>
		  <div><label for="ebay_prod_devid">Ebay API APPID</label><span><input name="esmodule[ebay_prod_appid]" id="ebay_prod_appid" class="textbox" type="text" value="{$SETTINGS_EBAY_API_APPID}" /></span></div>
		  <div><label for="ebay_prod_devid">Ebay API DEVID</label><span><input name="esmodule[ebay_prod_devid]" id="ebay_prod_devid" class="textbox" type="text" value="{$SETTINGS_EBAY_API_DEVID}" /></span></div>
		  <div><label for="ebay_prod_certid">Ebay API CERTID</label><span><input name="esmodule[ebay_prod_certid]" id="ebay_prod_certid" class="textbox" type="text" value="{$SETTINGS_EBAY_API_CERTID}" /></span></div>
		  <div><label for="ebay_prod_runame">Ebay API RuNAME</label><span><input name="esmodule[ebay_prod_runame]" id="ebay_prod_runame" class="textbox" type="text" value="{$SETTINGS_EBAY_API_RUNAME}" /></span></div>
		  <div>
			  <label for="ebay_countryid">Ebay Site</label><span>
				<select name="esmodule[ebay_countryid]">
					<option value="15" {if $SETTINGS_EBAY_API_COUNTRY == "15"}selected="yes"{/if}>Australia</option>
					<option value="16" {if $SETTINGS_EBAY_API_COUNTRY == "16"}selected="yes"{/if}>Austria</option>
					<option value="123" {if $SETTINGS_EBAY_API_COUNTRY == "123"}selected="yes"{/if}>Belgium (Dutch)</option>
					<option value="23" {if $SETTINGS_EBAY_API_COUNTRY == "23"}selected="yes"{/if}>Belgium (French)</option>
					<option value="2" {if $SETTINGS_EBAY_API_COUNTRY == "2"}selected="yes"{/if}>Canada (English)</option>
					<option value="210" {if $SETTINGS_EBAY_API_COUNTRY == "210"}selected="yes"{/if}>Canada (French)</option>
					<option value="71" {if $SETTINGS_EBAY_API_COUNTRY == "71"}selected="yes"{/if}>France</option>
					<option value="77" {if $SETTINGS_EBAY_API_COUNTRY == "7"}selected="yes"{/if}>Germany</option>
					<option value="201" {if $SETTINGS_EBAY_API_COUNTRY == "201"}selected="yes"{/if}>Hong Kong</option>
					<option value="203" {if $SETTINGS_EBAY_API_COUNTRY == "203"}selected="yes"{/if}>India</option>
					<option value="205" {if $SETTINGS_EBAY_API_COUNTRY == "205"}selected="yes"{/if}>Ireland</option>
					<option value="101" {if $SETTINGS_EBAY_API_COUNTRY == "101"}selected="yes"{/if}>Italy</option>
					<option value="207" {if $SETTINGS_EBAY_API_COUNTRY == "207"}selected="yes"{/if}>Malaysia</option>
					<option value="146" {if $SETTINGS_EBAY_API_COUNTRY == "146"}selected="yes"{/if}>Netherlands</option>
					<option value="211" {if $SETTINGS_EBAY_API_COUNTRY == "211"}selected="yes"{/if}>Philippines</option>
					<option value="212" {if $SETTINGS_EBAY_API_COUNTRY == "212"}selected="yes"{/if}>Poland</option>
					<option value="216" {if $SETTINGS_EBAY_API_COUNTRY == "216"}selected="yes"{/if}>Singapore</option>
					<option value="186" {if $SETTINGS_EBAY_API_COUNTRY == "186"}selected="yes"{/if}>Spain</option>
					<option value="193" {if $SETTINGS_EBAY_API_COUNTRY == "193"}selected="yes"{/if}>Switzerland</option>
					<option value="3" {if $SETTINGS_EBAY_API_COUNTRY == "3"}selected="yes"{/if}>UK</option>
					<option value="0" {if $SETTINGS_EBAY_API_COUNTRY == "0"}selected="yes"{/if}>United States</option>
				</select>
			</span>
		  </div>


		  <div>
			  <label for="ebay_prod_apiurl">Live/Test</label><span>
				<select name="esmodule[ebay_prod_apiurl]">
					<option value="sandbox" {if $SETTINGS_EBAY_API_APIURL == "sandbox"}selected="yes"{/if}>[TEST] - Sandbox</option>
					<option value="production" {if $SETTINGS_EBAY_API_APIURL == "production"}selected="yes"{/if}>[LIVE] - Production</option>
				</select>
			</span>
		  </div>

		  {if isset($EBAY_API_MESSAGE) && !empty($EBAY_API_MESSAGE)}
			  <div><label for="api_messages">API Message:</label><span>{$EBAY_API_MESSAGE}</span></div>
		  {/if}
		  <div><label for="ebay_token_e">{$LANG.ebay_sales.link_or_relink}</label><span><a href="?_g=plugins&type=plugins&module=ebay_sales&authaction=oauth1" class="button">{$LANG.ebay_sales.link_or_relink}</a></span></div>
		  <div><label for="ebay_token_e">{$LANG.ebay_sales.ebay_token_e}</label><span>{$EBAY_TOKEN_EXPIRES}</span></div>
		  <div><label for="force_revise_everything">{$LANG.ebay_sales.force_revise_everything}</label><span><a href="?_g=plugins&type=plugins&module=ebay_sales&doTheThing=force_revise_everything" class="button">{$LANG.ebay_sales.force_revise_everything}</a></span></div>
		  <div><label for="cron_last_ran">{$LANG.ebay_sales.cron_last_ran}</label><span>{$EBAY_CRON_LAST_RAN}</span></div>

	  </fieldset>

	<div class="form_control">
		<input type="submit" name="save" value="{$LANG.common.save}" />
	</div>

	<br/>

	  <fieldset><legend><a onmouseover="return escape('{$HELP_EBAY_CACHED_VALUES}')"><img src="{$STORE_URL}/modules/plugins/ebay_sales/images/help.png"></a> eBay Cached Values</legend>
		  <a href="{$EBAY_POSTAGE_LINK}" class="button">Update Cached Ebay Data (Shipping Methods, Store Categories, Return Durations, Profiles)</a>
	  </fieldset>

	  <fieldset><legend>{$LANG.ebay_sales.general_information}</legend>
		  <p>To get started with Ebay Sales please follow the steps below:
		  <ol>
			  <li>Enable this module (check status box and save)</li>
			  <li>Register for an account on the eBay Developer network. <a href="https://developer.ebay.com">https://developer.ebay.com</a></li>
			  <li>Generate a set of Sandbox and Production API Keys, this will give you the <b>AppID</b>, <b>DevID</b> and <b>CertID</b> required in the above configuration. This is done from your eBay developer account.</li>
			  <li>Within the Ebay developer account, navigate to the <b>Auth Tokens For Ebay</b> page. Complete the <b>Get a Token from eBay via your Application</b> creation steps. Add the following values.
				  <ul>
					  <li><b>oAuth Enabled</b> Checked/Yes </li>
					  <li><b>Your privacy policy URL:</b> {$STORE_URL} </li>
					  <li><b>Your auth accepted URL:</b> {$STORE_URL}/{$SKIN_VARS.admin_file}?ebay_linking_process=1</li>
					  <li><b>Your auth declined URL:</b> {$STORE_URL}/{$SKIN_VARS.admin_file}?ebay_linking_process=2</li>
				  </ul>
			  </li>
			  <li>Put your RuName, AppID, DevID and CerID & RuName from the ebay developer network into the plugin configuration above and save</li>
			  <li>Click the Link/Relink Ebay Account button, you should be asked to login to Ebay. Login and accept the T&C's (these are your own from the developer account). Once complete, you should be redirected back to the module.</li>
			  <li>Click on the &quot;Update Cached Ebay Data (Shipping Methods, Store Categories, Return Durations, Profiles)&quot; button. this step tests the connection to Ebay and updates the modules local configuration with a variety of data based on your Ebay account. You should see a success message. </li>
			  <li><b>IMPORTANT:</b> The module requires a CRON job (schedueld job) be setup to run background tasks. Schedule the following PHP script to run ONCE every THREE minutes or longer. (for example 5 or 10 minutes). <b>{$CC_ROOT_DIR}/modules/plugins/ebay_sales/cron/cron_ebaySales_processor.php</b>. Once the CRON job is setup, check the timestamp in the property &quot;CRON job last started (UTC)&quot; above. The time should update every few minutes as the job runs. If you do not see the time updating periodically the CRON is not working and needs to be investigated. </li>
		  </ol>
	  </fieldset>

  <input type="hidden" name="token" value="{$SESSION_TOKEN}" />
</form>
  </div>
  {$MODULE_ZONES}



<div id="inv_settings" class="tab_content">
	<form action="{$VAL_SELF}#inv_settings" method="post" enctype="multipart/form-data">
	{$CC_INV_EBAY_MAP}
	</form>
</div>

<div id="inv_push_ebay" class="tab_content">
	{$PUSH_TO_EBAY}
</div>

<div id="active_listings" class="tab_content">
	<h3>Active Items</h3>
	{if isset($ACTIVE_EBAY_LISTINGS)}
		<table>
			<thead>
				<tr>
					<td>Start Time</td>
					<td>Product Name</td>
					<td>Ebay Item ID</td>
					<td>Listing Format</td>
					<td>End Listing</td>
				</tr>
			</thead>
			<tbody>
		{foreach from=$ACTIVE_EBAY_LISTINGS item=listing}
			<tr>
				<td>{$listing.ebay_start_time}</td>
				<td><a href="?_g=products&action=edit&product_id={$listing.cubecart_product_id}">{$listing.name}</a></td>
				<td><a href="{$listing.ebay_listing_url}">{$listing.ebay_item_id}</a></td>
				<td>{if $listing.listing_format == "FixedPriceItem"}Buy It Now{else}Auction{/if}</td>
				<td style="text-align:center;"><a href="?_g={if $CC_LEGACY_MODE === true}modules{else}plugins{/if}&type=plugins&module=ebay_sales&eal=endListing&eiid={$listing.ebay_item_id}#active_listings"><img src="{$STORE_URL}/modules/plugins/ebay_sales/images/0.png" alt="End Listing" title="End Listing" /></a></td>
			</tr>
		{/foreach}
			</tbody>
		</table>
	{/if}
</div>

<div id="ebay_global_settings" class="tab_content">
	{$EBAY_GLOBAL_SETTINGS}
</div>

<div id="ebay_listing_history" class="tab_content">
	{$EBAY_LISTING_HISTORY}
</div>

<div id="error_log" class="tab_content">
	{$EBAY_ERROR_LOG}
</div>

<div id="ebay_html_templates" class="tab_content">
	{$EBAY_HTML_TEMPLATES}
</div>

<div id="ebay_templates_cust_tags" class="tab_content">
	{$EBAY_TEMPLATE_CUSTOM_TAGS}
</div>

<script type="text/JavaScript" src="{$STORE_URL}/modules/plugins/ebay_sales/js/popup.js"></script>
